/*
 * Decompiled with CFR 0.152.
 */
package jp.digitalmuseum.rt;

import ch.ethz.ssh2.Connection;
import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jp.digitalmuseum.rt.RemotiTunesConfiguration;
import jp.digitalmuseum.rt.gui.ConnectAction;
import jp.digitalmuseum.rt.gui.DisconnectAction;
import jp.digitalmuseum.rt.gui.ExitAction;
import jp.digitalmuseum.rt.gui.RemotiTunesFrame;

public class RemotiTunesMain {
    public static final String CONFIG_FILENAME = "config";
    public static final String ICON_FILENAME = "resources/remotitunes.png";
    private static RemotiTunesMain instance;
    private ExecutorService executor;
    private JmDNS rendezvous;
    private Connection connection;
    private ServiceInfo serviceInfo;
    private RemotiTunesFrame frame;
    private boolean isOSX;
    private JPopupMenu menu;
    private JMenuItem connectMenuItem;
    private JMenuItem disconnectMenuItem;
    private TrayIcon trayIcon;
    private boolean isFirstConnection = true;

    public static void main(String[] args) {
        RemotiTunesMain.getInstance();
    }

    public static RemotiTunesMain getInstance() {
        if (instance == null) {
            instance = new RemotiTunesMain();
        }
        return instance;
    }

    private RemotiTunesMain() {
        Runtime.getRuntime().addShutdownHook(new RemotiShutdownHook());
        this.executor = Executors.newSingleThreadExecutor();
        this.isOSX = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RemotiTunesMain.this.initGUI();
                RemotiTunesMain.this.loadConfiguration();
                RemotiTunesMain.this.updateGUI(false);
                RemotiTunesMain.this.frame.setVisible(true);
            }
        });
    }

    private void loadConfiguration() {
        RemotiTunesConfiguration config = null;
        File configFile = new File(CONFIG_FILENAME);
        if (configFile.exists() && configFile.isFile()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(configFile));
                config = (RemotiTunesConfiguration)ois.readObject();
            }
            catch (Exception ois) {
                // empty catch block
            }
        }
        if (config == null) {
            config = new RemotiTunesConfiguration();
            Rectangle rect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            config.frameX = (int)(rect.getWidth() - (double)this.frame.getWidth()) / 2;
            config.frameY = (int)(rect.getHeight() - (double)this.frame.getHeight()) / 2;
        }
        this.frame.applyConfiguration(config);
    }

    private void saveConfiguration(RemotiTunesConfiguration configuration) {
        File configFile = new File(CONFIG_FILENAME);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(configFile));
            oos.writeObject(configuration);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void connect() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RemotiTunesMain.this.connection == null && RemotiTunesMain.this.rendezvous == null) {
                    RemotiTunesMain.this.frame.setEnabled(false);
                    RemotiTunesConfiguration config = RemotiTunesMain.this.frame.getCurrentConfiguration(true);
                    try {
                        RemotiTunesMain.this.frame.setStatusText("\u30ea\u30e2\u30fc\u30c8\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3057\u3066\u3044\u307e\u3059...");
                        RemotiTunesMain.this.setupSSH(config);
                        RemotiTunesMain.this.frame.setStatusText("iTunes\u30b5\u30fc\u30d3\u30b9\u3092\u516c\u958b\u3057\u3066\u3044\u307e\u3059...");
                        RemotiTunesMain.this.setupRendezvous(config);
                        RemotiTunesMain.this.frame.setStatusText("\u63a5\u7d9a\u304c\u78ba\u7acb\u3055\u308c\u307e\u3057\u305f.");
                        RemotiTunesMain.this.updateGUI(true);
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        JOptionPane.showMessageDialog(RemotiTunesMain.this.frame, message);
                        RemotiTunesMain.this.frame.setStatusText(message);
                        RemotiTunesMain.this.frame.setConnected(false);
                        RemotiTunesMain.this.disconnect();
                        RemotiTunesMain.this.updateGUI(false);
                    }
                }
            }
        });
    }

    public void disconnect() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RemotiTunesMain.this.connection != null || RemotiTunesMain.this.rendezvous != null) {
                    RemotiTunesMain.this.frame.setEnabled(false);
                    RemotiTunesMain.this.frame.setStatusText("\u63a5\u7d9a\u3092\u5207\u3063\u3066\u3044\u307e\u3059...");
                    if (RemotiTunesMain.this.connection != null) {
                        RemotiTunesMain.this.connection.close();
                        RemotiTunesMain.this.connection = null;
                    }
                    if (RemotiTunesMain.this.rendezvous != null) {
                        RemotiTunesMain.this.rendezvous.unregisterService(RemotiTunesMain.this.serviceInfo);
                        RemotiTunesMain.this.rendezvous = null;
                    }
                    RemotiTunesMain.this.frame.setStatusText("\u63a5\u7d9a\u3092\u5207\u308a\u307e\u3057\u305f.");
                    RemotiTunesMain.this.updateGUI(false);
                }
            }
        });
    }

    private void setupSSH(RemotiTunesConfiguration config) throws Exception {
        this.connection = new Connection(config.remoteHost, config.remotePort);
        try {
            this.connection.connect();
        }
        catch (Exception e) {
            throw new Exception("\u30ea\u30e2\u30fc\u30c8\u30b5\u30fc\u30d0\u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f.", e);
        }
        boolean isAuthenticated = false;
        try {
            isAuthenticated = config.isAuthPassword ? this.connection.authenticateWithPassword(config.remoteUserName, config.password) : this.connection.authenticateWithPublicKey(config.remoteUserName, new File(config.privateKeyFileName), config.privateKeyPassword);
        }
        catch (IOException e) {
            throw new Exception("\u30ea\u30e2\u30fc\u30c8\u30b5\u30fc\u30d0\u306e\u30e6\u30fc\u30b6\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f.", e);
        }
        if (!isAuthenticated) {
            throw new Exception("\u30ea\u30e2\u30fc\u30c8\u30b5\u30fc\u30d0\u3067\u30e6\u30fc\u30b6\u8a8d\u8a3c\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f.");
        }
        this.connection.createLocalPortForwarder(config.localPort, "127.0.0.1", 3689);
    }

    private void setupRendezvous(RemotiTunesConfiguration config) throws IOException {
        this.serviceInfo = ServiceInfo.create((String)"_daap._tcp.local.", (String)"RemotiTunes", (int)config.localPort, (String)"iTunes remote proxy service.");
        this.rendezvous = JmDNS.create();
        this.rendezvous.registerService(this.serviceInfo);
    }

    private void initGUI() {
        BufferedImage iconImage;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            iconImage = ImageIO.read(this.getClass().getClassLoader().getResource(ICON_FILENAME));
        }
        catch (Exception e) {
            try {
                iconImage = ImageIO.read(new File(ICON_FILENAME));
            }
            catch (IOException e1) {
                iconImage = new BufferedImage(32, 32, 2);
            }
        }
        this.frame = new RemotiTunesFrame();
        this.frame.setIconImage(iconImage);
        this.frame.setDefaultCloseOperation(3);
        if (this.isOSX) {
            return;
        }
        this.menu = new JPopupMenu();
        this.connectMenuItem = this.menu.add(new ConnectAction("\u63a5\u7d9a\u3059\u308b"));
        this.disconnectMenuItem = this.menu.add(new DisconnectAction("\u5207\u65ad\u3059\u308b"));
        this.menu.addSeparator();
        this.menu.add(new ExitAction("\u7d42\u4e86\u3059\u308b"));
        this.trayIcon = new TrayIcon(iconImage, "RemotiTunes / \u30af\u30ea\u30c3\u30af\u3067\u30a6\u30a3\u30f3\u30c9\u30a6\u8868\u793a\u30fb\u975e\u8868\u793a\u5207\u308a\u63db\u3048");
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if ((e.getModifiers() & 0x10) == 16) {
                    RemotiTunesMain.this.frame.setVisible(!RemotiTunesMain.this.frame.isVisible());
                    if (RemotiTunesMain.this.frame.isVisible()) {
                        RemotiTunesMain.this.frame.requestFocus();
                    }
                } else if (e.isPopupTrigger()) {
                    RemotiTunesMain.this.menu.setLocation(e.getX(), e.getY());
                    RemotiTunesMain.this.menu.setInvoker(RemotiTunesMain.this.menu);
                    RemotiTunesMain.this.menu.setVisible(true);
                }
            }
        });
        try {
            SystemTray.getSystemTray().add(this.trayIcon);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    private void updateGUI(boolean isConnected) {
        this.frame.setConnected(isConnected);
        this.frame.setEnabled(true);
        if (this.isOSX) {
            return;
        }
        this.frame.setVisible(!isConnected);
        this.connectMenuItem.setEnabled(!isConnected);
        this.disconnectMenuItem.setEnabled(isConnected);
        if (isConnected && this.isFirstConnection) {
            this.isFirstConnection = false;
            this.trayIcon.displayMessage("\u63a5\u7d9a\u306b\u6210\u529f", "\u30c8\u30ec\u30a4\u30a2\u30a4\u30b3\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3059\u308b\u3068\u3001\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u8868\u793a\u30fb\u975e\u8868\u793a\u3092\u5207\u308a\u66ff\u3048\u3089\u308c\u307e\u3059\u3002", TrayIcon.MessageType.INFO);
        }
    }

    private class RemotiShutdownHook
    extends Thread {
        private RemotiShutdownHook() {
        }

        @Override
        public void run() {
            RemotiTunesConfiguration config = RemotiTunesMain.this.frame.getCurrentConfiguration(false);
            config.frameX = RemotiTunesMain.this.frame.getX();
            config.frameY = RemotiTunesMain.this.frame.getY();
            RemotiTunesMain.this.saveConfiguration(config);
            if (RemotiTunesMain.this.connection != null) {
                RemotiTunesMain.this.connection.close();
            }
            if (RemotiTunesMain.this.rendezvous != null) {
                RemotiTunesMain.this.rendezvous.unregisterService(RemotiTunesMain.this.serviceInfo);
            }
            RemotiTunesMain.this.executor.shutdownNow();
        }
    }
}

