/*
 * Decompiled with CFR 0.152.
 */
package jp.digitalmuseum.rt.gui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.digitalmuseum.rt.RemotiTunesConfiguration;
import jp.digitalmuseum.rt.gui.ConnectAction;
import jp.digitalmuseum.rt.gui.DisconnectAction;
import jp.digitalmuseum.rt.gui.OpenAction;
import jp.digitalmuseum.rt.gui.SwitchCardAction;

public class RemotiTunesFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jLocalSettingPanel = null;
    private JPanel jRemoteSettingPanel = null;
    private JLabel jLocalPortLabel = null;
    private JTextField jLocalPortTextField = null;
    private JLabel jHostAndPortLabel = null;
    private JTextField jHostTextField = null;
    private JLabel jUserNameLabel = null;
    private JTextField jUserNameTextField = null;
    private JLabel jAuthenticationTypeLabel = null;
    private JPanel jAuthenticationTypePanel = null;
    private JRadioButton jAuthPassRadioButton = null;
    private JRadioButton jAuthPublicKeyRadioButton = null;
    private JPanel jAuthenticationOptionPanel = null;
    private JPanel jAuthPasswordPanel = null;
    private JLabel jAuthPasswordLabel = null;
    private JPasswordField jAuthPasswordField = null;
    private JPanel jAuthPublicKeyPanel = null;
    private JLabel jAuthPublicKeyLabel = null;
    private JTextField jAuthPublicKeyTextField = null;
    private JButton jAuthPublicKeyButton = null;
    private JPanel jOperationPanel = null;
    private JButton jConnectButton = null;
    private JButton jDisconnectButton = null;
    private JPanel jHostAndPortPanel = null;
    private JLabel jAndLabel = null;
    private JTextField jPortTextField = null;
    private JLabel jStatusLabel = null;
    private JPanel jAuthPublicKeyPanel1 = null;
    private JPanel jAuthPublicKeyPanel2 = null;
    private JLabel jAuthPublicKeyPasswordLabel = null;
    private JPasswordField jAuthPublicKeyPasswordField = null;

    public RemotiTunesFrame() {
        this.initialize();
    }

    public void applyConfiguration(RemotiTunesConfiguration config) {
        this.getJLocalPortTextField().setText(String.valueOf(config.localPort));
        this.getJHostTextField().setText(config.remoteHost);
        this.getJPortTextField().setText(String.valueOf(config.remotePort));
        this.getJUserNameTextField().setText(config.remoteUserName);
        CardLayout cardLayout = (CardLayout)this.getJAuthenticationOptionPanel().getLayout();
        if (config.isAuthPassword) {
            this.getJAuthPassRadioButton().setSelected(true);
            cardLayout.show(this.getJAuthenticationOptionPanel(), this.getJAuthPasswordPanel().getName());
        } else {
            this.getJAuthPublicKeyRadioButton().setSelected(true);
            cardLayout.show(this.getJAuthenticationOptionPanel(), this.getJAuthPublicKeyPanel().getName());
        }
        this.getJAuthPasswordField().setText(config.password);
        this.getJAuthPublicKeyTextField().setText(config.privateKeyFileName);
        this.getJAuthPublicKeyPasswordField().setText(config.privateKeyPassword);
        this.setLocation(config.frameX, config.frameY);
    }

    public RemotiTunesConfiguration getCurrentConfiguration(boolean showMessage) {
        JTextField focusComponent;
        RemotiTunesConfiguration config;
        block6: {
            block5: {
                config = new RemotiTunesConfiguration();
                focusComponent = null;
                try {
                    config.localPort = Integer.valueOf(this.getJLocalPortTextField().getText());
                }
                catch (NumberFormatException nfe) {
                    if (!showMessage) break block5;
                    JOptionPane.showMessageDialog(this, "\u30ed\u30fc\u30ab\u30eb\u30db\u30b9\u30c8\u306e\u30dd\u30fc\u30c8\u306f\u534a\u89d2\u6570\u5b57\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044.");
                    focusComponent = this.getJLocalPortTextField();
                }
            }
            try {
                config.remotePort = Integer.valueOf(this.getJPortTextField().getText());
            }
            catch (NumberFormatException nfe) {
                if (!showMessage) break block6;
                JOptionPane.showMessageDialog(this, "\u30ea\u30e2\u30fc\u30c8\u30db\u30b9\u30c8\u306e\u30dd\u30fc\u30c8\u306f\u534a\u89d2\u6570\u5b57\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044.");
                focusComponent = this.getJPortTextField();
            }
        }
        config.remoteHost = this.getJHostTextField().getText();
        config.remoteUserName = this.getJUserNameTextField().getText();
        config.isAuthPassword = this.getJAuthPassRadioButton().isSelected();
        config.password = String.valueOf(this.getJAuthPasswordField().getPassword());
        config.privateKeyFileName = this.getJAuthPublicKeyTextField().getText();
        config.privateKeyPassword = String.valueOf(this.getJAuthPublicKeyPasswordField().getPassword());
        if (focusComponent != null) {
            focusComponent.requestFocusInWindow();
        }
        return config;
    }

    public void setStatusText(String text) {
        this.getJOperationPanel();
        this.jStatusLabel.setText(text);
    }

    public void setConnected(boolean isConnected) {
        this.getJLocalPortTextField().setEnabled(!isConnected);
        this.getJHostTextField().setEnabled(!isConnected);
        this.getJPortTextField().setEnabled(!isConnected);
        this.getJUserNameTextField().setEnabled(!isConnected);
        this.getJAuthPassRadioButton().setEnabled(!isConnected);
        this.getJAuthPublicKeyRadioButton().setEnabled(!isConnected);
        this.getJAuthPasswordField().setEnabled(!isConnected);
        this.getJAuthPublicKeyTextField().setEnabled(!isConnected);
        this.getJAuthPublicKeyButton().setEnabled(!isConnected);
        this.getJAuthPublicKeyPasswordField().setEnabled(!isConnected);
        this.getJConnectButton().setEnabled(!isConnected);
        this.getJDisconnectButton().setEnabled(isConnected);
    }

    private void initialize() {
        this.setSize(560, 380);
        this.setMinimumSize(new Dimension(560, 380));
        this.setContentPane(this.getJContentPane());
        this.setTitle("RemotiTunes");
        ButtonGroup group = new ButtonGroup();
        group.add(this.getJAuthPassRadioButton());
        group.add(this.getJAuthPublicKeyRadioButton());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getJLocalSettingPanel(), null);
            this.jContentPane.add((Component)this.getJRemoteSettingPanel(), null);
            this.jContentPane.add((Component)this.getJOperationPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getJLocalSettingPanel() {
        if (this.jLocalSettingPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridx = 1;
            this.jLocalPortLabel = new JLabel();
            this.jLocalPortLabel.setText("\u30dd\u30fc\u30c8:");
            this.jLocalPortLabel.setPreferredSize(new Dimension(100, 13));
            this.jLocalSettingPanel = new JPanel();
            this.jLocalSettingPanel.setLayout(new GridBagLayout());
            this.jLocalSettingPanel.setBorder(BorderFactory.createTitledBorder(null, "\u30ed\u30fc\u30ab\u30eb\u30db\u30b9\u30c8\u306e\u8a2d\u5b9a (DAAP)", 0, 0, new Font("MS UI Gothic", 0, 12), Color.black));
            this.jLocalSettingPanel.add((Component)this.jLocalPortLabel, gridBagConstraints1);
            this.jLocalSettingPanel.add((Component)this.getJLocalPortTextField(), gridBagConstraints);
        }
        return this.jLocalSettingPanel;
    }

    private JPanel getJRemoteSettingPanel() {
        if (this.jRemoteSettingPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 3;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridy = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.gridy = 2;
            this.jAuthenticationTypeLabel = new JLabel();
            this.jAuthenticationTypeLabel.setText("\u8a8d\u8a3c\u65b9\u6cd5:");
            this.jAuthenticationTypeLabel.setPreferredSize(new Dimension(100, 13));
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints5.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.gridy = 1;
            this.jUserNameLabel = new JLabel();
            this.jUserNameLabel.setText("\u30e6\u30fc\u30b6\u540d:");
            this.jUserNameLabel.setPreferredSize(new Dimension(100, 13));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.gridy = 0;
            this.jHostAndPortLabel = new JLabel();
            this.jHostAndPortLabel.setText("\u30db\u30b9\u30c8\u3068\u30dd\u30fc\u30c8:");
            this.jHostAndPortLabel.setPreferredSize(new Dimension(100, 13));
            this.jRemoteSettingPanel = new JPanel();
            this.jRemoteSettingPanel.setLayout(new GridBagLayout());
            this.jRemoteSettingPanel.setBorder(BorderFactory.createTitledBorder(null, "\u30ea\u30e2\u30fc\u30c8\u30db\u30b9\u30c8\u306e\u8a2d\u5b9a (SSH)", 0, 0, new Font("MS UI Gothic", 0, 12), Color.black));
            this.jRemoteSettingPanel.add((Component)this.jHostAndPortLabel, gridBagConstraints2);
            this.jRemoteSettingPanel.add((Component)this.getJHostAndPortPanel(), gridBagConstraints3);
            this.jRemoteSettingPanel.add((Component)this.jUserNameLabel, gridBagConstraints4);
            this.jRemoteSettingPanel.add((Component)this.getJUserNameTextField(), gridBagConstraints5);
            this.jRemoteSettingPanel.add((Component)this.jAuthenticationTypeLabel, gridBagConstraints6);
            this.jRemoteSettingPanel.add((Component)this.getJAuthenticationTypePanel(), gridBagConstraints7);
            this.jRemoteSettingPanel.add((Component)this.getJAuthenticationOptionPanel(), gridBagConstraints8);
        }
        return this.jRemoteSettingPanel;
    }

    private JTextField getJLocalPortTextField() {
        if (this.jLocalPortTextField == null) {
            this.jLocalPortTextField = new JTextField();
            this.jLocalPortTextField.setColumns(10);
        }
        return this.jLocalPortTextField;
    }

    private JTextField getJHostTextField() {
        if (this.jHostTextField == null) {
            this.jHostTextField = new JTextField();
            this.jHostTextField.setColumns(20);
        }
        return this.jHostTextField;
    }

    private JTextField getJUserNameTextField() {
        if (this.jUserNameTextField == null) {
            this.jUserNameTextField = new JTextField();
            this.jUserNameTextField.setColumns(16);
        }
        return this.jUserNameTextField;
    }

    private JPanel getJAuthenticationTypePanel() {
        if (this.jAuthenticationTypePanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.jAuthenticationTypePanel = new JPanel();
            this.jAuthenticationTypePanel.setLayout(flowLayout);
            this.jAuthenticationTypePanel.add((Component)this.getJAuthPassRadioButton(), null);
            this.jAuthenticationTypePanel.add((Component)this.getJAuthPublicKeyRadioButton(), null);
        }
        return this.jAuthenticationTypePanel;
    }

    private JRadioButton getJAuthPassRadioButton() {
        if (this.jAuthPassRadioButton == null) {
            this.jAuthPassRadioButton = new JRadioButton();
            this.jAuthPassRadioButton.setAction(new SwitchCardAction(this.getJAuthenticationOptionPanel(), this.getJAuthPasswordPanel().getName()));
            this.jAuthPassRadioButton.setText("\u30d1\u30b9\u30ef\u30fc\u30c9");
        }
        return this.jAuthPassRadioButton;
    }

    private JRadioButton getJAuthPublicKeyRadioButton() {
        if (this.jAuthPublicKeyRadioButton == null) {
            this.jAuthPublicKeyRadioButton = new JRadioButton();
            this.jAuthPublicKeyRadioButton.setAction(new SwitchCardAction(this.getJAuthenticationOptionPanel(), this.getJAuthPublicKeyPanel().getName()));
            this.jAuthPublicKeyRadioButton.setText("\u516c\u958b\u9375");
        }
        return this.jAuthPublicKeyRadioButton;
    }

    private JPanel getJAuthenticationOptionPanel() {
        if (this.jAuthenticationOptionPanel == null) {
            this.jAuthenticationOptionPanel = new JPanel();
            this.jAuthenticationOptionPanel.setLayout(new CardLayout());
            this.jAuthenticationOptionPanel.add((Component)this.getJAuthPasswordPanel(), this.getJAuthPasswordPanel().getName());
            this.jAuthenticationOptionPanel.add((Component)this.getJAuthPublicKeyPanel(), this.getJAuthPublicKeyPanel().getName());
        }
        return this.jAuthenticationOptionPanel;
    }

    private JPanel getJAuthPasswordPanel() {
        if (this.jAuthPasswordPanel == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setAlignment(0);
            this.jAuthPasswordLabel = new JLabel();
            this.jAuthPasswordLabel.setText("\u30d1\u30b9\u30ef\u30fc\u30c9:");
            this.jAuthPasswordPanel = new JPanel();
            this.jAuthPasswordPanel.setLayout(flowLayout1);
            this.jAuthPasswordPanel.setName("jAuthPasswordPanel");
            this.jAuthPasswordPanel.add((Component)this.jAuthPasswordLabel, null);
            this.jAuthPasswordPanel.add((Component)this.getJAuthPasswordField(), null);
        }
        return this.jAuthPasswordPanel;
    }

    private JPasswordField getJAuthPasswordField() {
        if (this.jAuthPasswordField == null) {
            this.jAuthPasswordField = new JPasswordField();
            this.jAuthPasswordField.setColumns(16);
        }
        return this.jAuthPasswordField;
    }

    private JPanel getJAuthPublicKeyPanel() {
        if (this.jAuthPublicKeyPanel == null) {
            this.jAuthPublicKeyLabel = new JLabel();
            this.jAuthPublicKeyLabel.setText("\u79d8\u5bc6\u9375:");
            this.jAuthPublicKeyPanel = new JPanel();
            this.jAuthPublicKeyPanel.setLayout(new BoxLayout(this.getJAuthPublicKeyPanel(), 1));
            this.jAuthPublicKeyPanel.setName("jAuthPublicKeyPanel");
            this.jAuthPublicKeyPanel.add((Component)this.getJAuthPublicKeyPanel1(), null);
            this.jAuthPublicKeyPanel.add((Component)this.getJAuthPublicKeyPanel2(), null);
        }
        return this.jAuthPublicKeyPanel;
    }

    private JTextField getJAuthPublicKeyTextField() {
        if (this.jAuthPublicKeyTextField == null) {
            this.jAuthPublicKeyTextField = new JTextField();
            this.jAuthPublicKeyTextField.setColumns(16);
        }
        return this.jAuthPublicKeyTextField;
    }

    private JButton getJAuthPublicKeyButton() {
        if (this.jAuthPublicKeyButton == null) {
            this.jAuthPublicKeyButton = new JButton();
            this.jAuthPublicKeyButton.setAction(new OpenAction(this, this.getJAuthPublicKeyTextField()));
            this.jAuthPublicKeyButton.setText("\u9078\u629e");
        }
        return this.jAuthPublicKeyButton;
    }

    private JPanel getJOperationPanel() {
        if (this.jOperationPanel == null) {
            this.jStatusLabel = new JLabel();
            this.jStatusLabel.setText("");
            FlowLayout flowLayout3 = new FlowLayout();
            flowLayout3.setAlignment(2);
            this.jOperationPanel = new JPanel();
            this.jOperationPanel.setLayout(flowLayout3);
            this.jOperationPanel.add((Component)this.jStatusLabel, null);
            this.jOperationPanel.add((Component)this.getJConnectButton(), null);
            this.jOperationPanel.add((Component)this.getJDisconnectButton(), null);
        }
        return this.jOperationPanel;
    }

    private JButton getJConnectButton() {
        if (this.jConnectButton == null) {
            this.jConnectButton = new JButton();
            this.jConnectButton.setAction(new ConnectAction());
            this.jConnectButton.setText("\u63a5\u7d9a");
        }
        return this.jConnectButton;
    }

    private JButton getJDisconnectButton() {
        if (this.jDisconnectButton == null) {
            this.jDisconnectButton = new JButton();
            this.jDisconnectButton.setAction(new DisconnectAction());
            this.jDisconnectButton.setText("\u5207\u65ad");
        }
        return this.jDisconnectButton;
    }

    private JPanel getJHostAndPortPanel() {
        if (this.jHostAndPortPanel == null) {
            this.jAndLabel = new JLabel();
            this.jAndLabel.setText(":");
            FlowLayout flowLayout4 = new FlowLayout();
            flowLayout4.setAlignment(0);
            this.jHostAndPortPanel = new JPanel();
            this.jHostAndPortPanel.setLayout(flowLayout4);
            this.jHostAndPortPanel.add((Component)this.getJHostTextField(), null);
            this.jHostAndPortPanel.add((Component)this.jAndLabel, null);
            this.jHostAndPortPanel.add((Component)this.getJPortTextField(), null);
        }
        return this.jHostAndPortPanel;
    }

    private JTextField getJPortTextField() {
        if (this.jPortTextField == null) {
            this.jPortTextField = new JTextField();
            this.jPortTextField.setColumns(10);
        }
        return this.jPortTextField;
    }

    private JPanel getJAuthPublicKeyPanel1() {
        if (this.jAuthPublicKeyPanel1 == null) {
            FlowLayout flowLayout2 = new FlowLayout();
            flowLayout2.setAlignment(0);
            this.jAuthPublicKeyPanel1 = new JPanel();
            this.jAuthPublicKeyPanel1.setLayout(flowLayout2);
            this.jAuthPublicKeyPanel1.add((Component)this.jAuthPublicKeyLabel, null);
            this.jAuthPublicKeyPanel1.add((Component)this.getJAuthPublicKeyTextField(), null);
            this.jAuthPublicKeyPanel1.add((Component)this.getJAuthPublicKeyButton(), null);
        }
        return this.jAuthPublicKeyPanel1;
    }

    private JPanel getJAuthPublicKeyPanel2() {
        if (this.jAuthPublicKeyPanel2 == null) {
            FlowLayout flowLayout5 = new FlowLayout();
            flowLayout5.setAlignment(0);
            this.jAuthPublicKeyPasswordLabel = new JLabel();
            this.jAuthPublicKeyPasswordLabel.setText("\u79d8\u5bc6\u9375\u306e\u30d1\u30b9\u30ef\u30fc\u30c9 (\u3082\u3057\u3042\u308c\u3070):");
            this.jAuthPublicKeyPanel2 = new JPanel();
            this.jAuthPublicKeyPanel2.setLayout(flowLayout5);
            this.jAuthPublicKeyPanel2.add((Component)this.jAuthPublicKeyPasswordLabel, null);
            this.jAuthPublicKeyPanel2.add((Component)this.getJAuthPublicKeyPasswordField(), null);
        }
        return this.jAuthPublicKeyPanel2;
    }

    private JPasswordField getJAuthPublicKeyPasswordField() {
        if (this.jAuthPublicKeyPasswordField == null) {
            this.jAuthPublicKeyPasswordField = new JPasswordField();
            this.jAuthPublicKeyPasswordField.setColumns(16);
        }
        return this.jAuthPublicKeyPasswordField;
    }
}

